/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioFieldAssignments;
import filenet.sim.api.VWScenarioRoutingType;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public final class VWScenarioStepSettings
implements Serializable {
    public static final int EXECUTION_TYPE_DEFAULT = 1;
    public static final int EXECUTION_TYPE_ALL = 2;
    public static final int EXECUTION_TYPE_ONE = 4;
    public static final int LVALUE = 0;
    public static final int RVALUE = 1;
    private VWScenarioWorkflowDefinition m_scenarioWFDef = null;
    private VWMapDefinition m_mapDefinition = null;
    private VWMapNode m_mapNode = null;
    private VWScenarioTimeDuration m_duration = null;
    private VWScenarioTimeDuration m_periodDuration = null;
    private VWScenarioTimeDuration m_pauseDuration = null;
    private boolean m_keepResource = true;
    private int m_executionType = 1;
    private int m_routingType = 2;
    private VWScenarioFieldAssignments m_fieldAssignments = null;
    private String[][] m_preAssignments = null;
    private String[][] m_postAssignments = null;
    private Map m_routeWeights = Collections.synchronizedMap(new HashMap());

    protected VWScenarioStepSettings(VWScenarioWorkflowDefinition scenarioWFDef, VWMapDefinition mapDefinition, VWMapNode mapNode) throws VWException {
        this.m_scenarioWFDef = scenarioWFDef;
        this.m_mapDefinition = mapDefinition;
        this.m_mapNode = mapNode;
        this.m_duration = new VWScenarioTimeDuration("0", 2);
    }

    public VWScenarioTimeDuration getDuration() {
        return this.m_duration;
    }

    public void setDuration(VWScenarioTimeDuration duration) {
        this.m_duration = duration;
    }

    public VWScenarioTimeDuration getPeriodDuration() {
        return this.m_periodDuration;
    }

    public void setPeriodDuration(VWScenarioTimeDuration periodDuration) {
        this.m_periodDuration = periodDuration;
    }

    public VWScenarioTimeDuration getPauseDuration() {
        return this.m_pauseDuration;
    }

    public void setPauseDuration(VWScenarioTimeDuration pauseDuration) {
        this.m_pauseDuration = pauseDuration;
    }

    public boolean getKeepResource() {
        return this.m_keepResource;
    }

    public void setKeepResource(boolean keepResource) {
        this.m_keepResource = keepResource;
    }

    protected int getExecutionType() {
        return this.m_executionType;
    }

    protected void setExecutionType(int type) throws VWException {
        if (type != 1 && type != 2 && type != 4) {
            throw new VWException("sim.api.VWScenarioStepSettingsInvalidExecutionType", "The type {0} is not a valid execution type.", new Integer(type));
        }
        this.m_executionType = type;
    }

    public int getRoutingType() {
        return this.m_routingType;
    }

    public void setRoutingType(int type) throws VWException {
        if (!VWScenarioRoutingType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioStepSettingsInvalidRoutingType", "The type {0} is not a valid routing type.", new Integer(type));
        }
        this.m_routingType = type;
    }

    public int getRouteWeight(int routeId) throws VWException {
        Integer theRouteId = new Integer(routeId);
        if (!this.validateRouteId(routeId)) {
            throw new VWException("sim.api.VWScenarioStepSettings.InvalidRouteIdParameter", "Route id {0} is not a valid route of the associated step definition.", String.valueOf(routeId));
        }
        if (this.m_routeWeights.containsKey(theRouteId)) {
            return (Integer)this.m_routeWeights.get(theRouteId);
        }
        return 0;
    }

    public void setRouteWeight(int routeId, int weight) throws VWException {
        Integer theRouteId = new Integer(routeId);
        if (!this.validateRouteId(routeId)) {
            throw new VWException("sim.api.VWScenarioStepSettings.InvalidRouteIdParameter", "Route id {0} is not a valid route of the associated step definition.", String.valueOf(routeId));
        }
        if (weight < 0 || weight > 100) {
            throw new VWException("sim.api.VWScenarioStepSettings.InvalidRouteWeightParameter", "The route weight value of {0} is invalid.  Route weights must be between 0 and 100 (inclusive).", String.valueOf(weight));
        }
        this.m_routeWeights.put(theRouteId, new Integer(weight));
    }

    protected void setRouteWeightUsingIndex(int routeIndex, int weight) throws VWException {
        int routeId = -1;
        VWRouteDefinition[] routes = this.m_mapNode.getNextRoutes();
        if (routes != null && routes.length > routeIndex) {
            routeId = routes[routeIndex].getRouteId();
        }
        this.setRouteWeight(routeId, weight);
    }

    protected VWScenarioFieldAssignments newFieldAssignments() {
        return new VWScenarioFieldAssignments(this);
    }

    protected void setFieldAssignments(VWScenarioFieldAssignments fAssignments) {
        fAssignments.setStepSettings(this);
        this.m_fieldAssignments = fAssignments;
    }

    protected VWScenarioFieldAssignments getFieldAssignments() {
        return this.m_fieldAssignments;
    }

    public String[][] getPreAssignments() {
        return this.m_preAssignments;
    }

    public void setPreAssignments(String[][] thePreAssignments) throws VWException {
        for (int i = 0; i < thePreAssignments.length; ++i) {
            if (thePreAssignments[i].length != 2) {
                throw new VWException("sim.api.VWScenarioStepSettings.AssignmentArrayWrongDimension", "Assignment array wrong dimension, row {0} has {1} elements, should have 2 (representing the left and right values of the assignment)", String.valueOf(i), String.valueOf(thePreAssignments[i].length));
            }
            if (thePreAssignments[i][0] != null && thePreAssignments[i][1] != null) continue;
            throw new VWException("sim.api.VWScenarioStepSettings.AssignmentArrayNullElement", "Assignment array contains a null entry in row {0}", String.valueOf(i));
        }
        this.m_preAssignments = thePreAssignments;
    }

    public String[][] getPostAssignments() {
        return this.m_postAssignments;
    }

    public void setPostAssignments(String[][] thePostAssignments) throws VWException {
        for (int i = 0; i < thePostAssignments.length; ++i) {
            if (thePostAssignments[i].length != 2) {
                throw new VWException("sim.api.VWScenarioStepSettings.AssignmentArrayWrongDimension", "Assignment array wrong dimension, row {0} has {1} elements, should have 2 (representing the left and right values of the assignment)", String.valueOf(i), String.valueOf(thePostAssignments[i].length));
            }
            if (thePostAssignments[i][0] != null && thePostAssignments[i][1] != null) continue;
            throw new VWException("sim.api.VWScenarioStepSettings.AssignmentArrayNullElement", "Assignment array contains a null entry in row {0}", String.valueOf(i));
        }
        this.m_postAssignments = thePostAssignments;
    }

    public void validate(Vector EDefVector) throws VWException {
        VWScenarioValidationError theError;
        VWString theMessage;
        VWCompiledExpr rCompRes;
        boolean expectedRValueIsArray;
        VWString theMessage2;
        int k;
        String[] theErrorStrings;
        String[][] a;
        if (this.getDuration() != null) {
            VWScenarioTimeType.validate(this.getDuration(), null, 8, this.m_mapNode.getName(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), new Integer(this.m_mapNode.getStepId()), this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), EDefVector);
        } else {
            VWString theMessage3 = new VWString("sim.api.VWScenarioStepSettings.DurationNotDefined", "Duration value undefined for step {0}.", this.m_mapNode.getName());
            VWScenarioValidationError theError2 = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), null, theMessage3.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
            EDefVector.addElement(theError2);
        }
        if (this.getPeriodDuration() != null) {
            VWScenarioTimeType.validate(this.getPeriodDuration(), null, 8, this.m_mapNode.getName(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), new Integer(this.m_mapNode.getStepId()), this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), EDefVector);
        }
        if (this.getPauseDuration() != null) {
            VWScenarioTimeType.validate(this.getPauseDuration(), null, 8, this.m_mapNode.getName(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), new Integer(this.m_mapNode.getStepId()), this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), EDefVector);
        }
        if (this.getRoutingType() == 2 && this.m_mapNode.getNextRoutes() != null) {
            VWScenarioValidationError theError3;
            Iterator routeWeights = this.m_routeWeights.values().iterator();
            int totalWeight = 0;
            while (routeWeights.hasNext()) {
                int routeWeight = (Integer)routeWeights.next();
                if (this.m_mapNode.getSplitType() == 1 && routeWeight > 100) {
                    VWString theMessage4 = new VWString("sim.api.VWScenarioStepSettings.InvalidAndRouteWeight", "Route weight must be less than or equal to 100, the current weight is {0}.", new Integer(totalWeight));
                    VWScenarioValidationError theError4 = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), null, theMessage4.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                    EDefVector.addElement(theError4);
                }
                totalWeight += routeWeight;
            }
            if (this.m_mapNode.getSplitType() == 2 && totalWeight > 100) {
                VWString theMessage5 = new VWString("sim.api.VWScenarioStepSettings.InvalidOrRouteWeightTotal", "Total route weight must be <= 100. Current total is {0}.", new Integer(totalWeight));
                theError3 = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), null, theMessage5.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                EDefVector.addElement(theError3);
            }
            if (totalWeight == 0) {
                VWString theMessage6 = new VWString("sim.api.VWScenarioStepSettings.ZeroRouteWeightTotal", "Total route weight is zero, work item will terminate at this step.", new Integer(totalWeight));
                theError3 = new VWScenarioValidationError(8, 2, this.m_mapNode.getName(), null, theMessage6.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                EDefVector.addElement(theError3);
            }
        }
        if (this.m_fieldAssignments != null) {
            this.m_fieldAssignments.validate(EDefVector);
        }
        if ((a = this.getPreAssignments()) != null) {
            for (int i = 0; i < a.length; ++i) {
                VWCompiledRefExpr lCompRes = new VWCompiledRefExpr();
                theErrorStrings = VWExpr.compileVWExpr(":=" + a[i][0], this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), null, null, true, lCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (k = 0; k < errorCount; ++k) {
                        theMessage2 = new VWString("sim.api.VWScenarioStepSettings.PreAsgnBadLValue", "Step pre-Assignment[{0}], the Left side of assignment, {1}, is not a valid LValue, Syntax Error {2}", String.valueOf(i), a[i][0], theErrorStrings[k]);
                        VWScenarioValidationError theError5 = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), a[i][0], theMessage2.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                        EDefVector.addElement(theError5);
                    }
                    continue;
                }
                int expectedRValueType = lCompRes.getResultType();
                expectedRValueIsArray = lCompRes.getResultIsArray();
                rCompRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(a[i][1], this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), null, null, true, rCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int j = 0; j < errorCount; ++j) {
                        theMessage = new VWString("sim.api.VWScenarioStepSettings.PreAsgnRValSyntaxError", "Step Pre-Assignment[{0}], RValue (expected type is {1}), syntax error: {2}", String.valueOf(i), VWFieldType.getLocalizedString(expectedRValueType) + (expectedRValueIsArray ? " array " : ""), theErrorStrings[j]);
                        theError = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), a[i][0], theMessage.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                        EDefVector.addElement(theError);
                    }
                    continue;
                }
                if (VWScenarioDefinition.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                VWString theMessage7 = new VWString("sim.api.VWScenarioStepSettings.PreAsgnTypeMismatch", "Step Pre-Assignment[{0}],  Incompatible type, expected {1}, found {2}.", String.valueOf(i), VWFieldType.getLocalizedString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() ? "[ ]" : ""), VWFieldType.getLocalizedString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() ? "[ ]" : ""));
                VWScenarioValidationError theError6 = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), a[i][0], theMessage7.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                EDefVector.addElement(theError6);
            }
        }
        if ((a = this.getPostAssignments()) != null) {
            for (int i = 0; i < a.length; ++i) {
                VWCompiledRefExpr lCompRes = new VWCompiledRefExpr();
                theErrorStrings = VWExpr.compileVWExpr(":=" + a[i][0], this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), null, null, true, lCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (k = 0; k < errorCount; ++k) {
                        theMessage2 = new VWString("sim.api.VWScenarioStepSettings.PostAsgnBadLValue", "Step post-Assignment[{0}], the Left side of assignment, {1}, is not a valid LValue, Syntax Error {2}", String.valueOf(i), a[i][0], theErrorStrings[k]);
                        VWScenarioValidationError theError7 = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), a[i][0], theMessage2.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                        EDefVector.addElement(theError7);
                    }
                    continue;
                }
                int expectedRValueType = lCompRes.getResultType();
                expectedRValueIsArray = lCompRes.getResultIsArray();
                rCompRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(a[i][1], this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), null, null, true, rCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int j = 0; j < errorCount; ++j) {
                        theMessage = new VWString("sim.api.VWScenarioStepSettings.PostAsgnRValSyntaxError", "Step Post-Assignment[{0}], RValue (expected type is {1}), syntax error: {2}", String.valueOf(i), VWFieldType.getLocalizedString(expectedRValueType) + (expectedRValueIsArray ? " array " : ""), theErrorStrings[j]);
                        theError = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), a[i][0], theMessage.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                        EDefVector.addElement(theError);
                    }
                    continue;
                }
                if (VWScenarioDefinition.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                VWString theMessage8 = new VWString("sim.api.VWScenarioStepSettings.PostAsgnTypeMismatch", "Step Post-Assignment[{0}],  Incompatible type, expected {1}, found {2}.", String.valueOf(i), VWFieldType.getLocalizedString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() ? "[ ]" : ""), VWFieldType.getLocalizedString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() ? "[ ]" : ""));
                VWScenarioValidationError theError8 = new VWScenarioValidationError(8, 1, this.m_mapNode.getName(), a[i][0], theMessage8.toString(), this.m_scenarioWFDef.getWorkflowDefinition().getName(), this.m_mapDefinition.getName(), this.m_mapNode.getStepId());
                EDefVector.addElement(theError8);
            }
        }
    }

    protected void setMapNode(VWMapNode mapNode) throws VWException {
        this.m_mapNode = mapNode;
        Iterator routeIds = this.m_routeWeights.keySet().iterator();
        while (routeIds.hasNext()) {
            if (this.validateRouteId((Integer)routeIds.next())) continue;
            routeIds.remove();
        }
    }

    protected boolean validateRouteId(int routeId) throws VWException {
        boolean routeFound = false;
        VWRouteDefinition[] routes = this.m_mapNode.getNextRoutes();
        if (routes != null) {
            for (int i = 0; i < routes.length; ++i) {
                if (routeId != routes[i].getRouteId()) continue;
                routeFound = true;
                break;
            }
        }
        return routeFound;
    }

    protected VWScenarioWorkflowDefinition getScenarioWorkflow() {
        return this.m_scenarioWFDef;
    }

    protected VWMapDefinition getMapDefinition() {
        return this.m_mapDefinition;
    }

    protected VWMapNode getMapNode() {
        return this.m_mapNode;
    }
}

